# Build Sage 9.5.beta9 + many packages on Cygwin

2022-01-08

## Overview

On Cygwin 3.3.3-1 on Windows 10, an attempt by Samuel Lelièvre
to build Sage 9.5.beta9 together with many tickets planned for
inclusion in the next development release, as guessed by taking
a peek at Volker Braun's development branch.

- #33104: Fix references to `doc-clean`
- #32759: `./configure --disable-doc`
- #32860: Inaccurate documentation for number field `elements_of_norm`
- #33097: some typos in `combinat` and `modular`
- #33087: `build/bin/sage-clone-source`: Use "trac" as name of the remote
- #33046: gap spkg creates absolute symlinks
- #32990: pickling support for real balls and related objects
- #32977: `sage.features`: Remove dependency on `sage.misc.lazy_string`
- #32938: deactivation of the u-prefix doctest handler
- #32245: Quaternion ideals sometimes compare incorrectly
- #30875: Random elements of AA aren't random
- #29784: Update section "Sage Development Process" in Developer's Guide
- #33080: Fix scipy-1.7.2 build failure on Cygwin
- #32868: configure tarball misses some generated files
- #33036: random doctest failure in src/sage/crypto/util.py
- #32980: unmarked `# long time` tests in `graphs/generators/classical_geometries.py`
- #32972: Unmarked `# long time` tests in `characteristic_cohomology_class.py`
- #32971: unmarked `# long time` tests in `ell_number_field.py`
- #30677: Add VS Code config for `SAGE_ROOT/venv`
- #33068: GH Actions: Remove ubuntu-groovy
- #33058: doctest in `generic_graph.py` can fail due to rounding error
- #33019: remove more `py2` or `py3` tags in doctests
- #33031: add tolerance to `is_hermitian()` for sparse "double" matrices
- #32904: Add version constraints for sage-conf, clean the sage-conf sdist
- #31672: Invalid latex repr from FreeAlgebra `_latex_` / `repr_lincomb`
- #32062: GH Actions: Deploy sdists to PyPI
- #33066: OpenSSL 3.0.1 security update
- #32703: GH Actions (macOS): Run a job for "make build-local" first, cache image for job "make build"
- #32113: GH Actions: conda-forge tests broken
- #30766: Experimental support for Python 3.10 in Sage 9.5
- #33057: fix incorrect doctest in solve_integer of binary quadratic forms
- #33067: tox / GH Actions: Fix docker-based tests after #31386
- #29039: pip-installable version of package sage_conf - installs non-Python bits of the Sage distribution in `~/.sage`
- #33082: segfault: illegal (popcnt) instruction in primecount
- #33073: Segmentation fault in face iterator (still)
- #29310: `make distclean` should not run `./configure`
- #13637: Add multiplicative order to complex interval field
- #33040: Update matplotlib to 3.5
- #33012: Bug in bitset_copy_flex
- #32676: `logic.print_table` changes your truthtable
- #31580: Update matplotlib to 3.4
- #33060: pytest: Declare dependencies
- #33059: conda-forge-macos-standard: pyzmq build fails
- #33043: Upgrade: lcalc 2.0.5 to allow building on Cygwin
- #33042: givaro spkg-configure: Reject too new versions
- #32907: Update singular to 4.2.1p3

The build fails on sagemath_doc_html-none
but sagelib is built so most of Sage can be used.


## Setup

Laptop

- Acer Aspire A314-22
- Processor: AMD Ryzen 5 3500U with Radeon Vega Mobile Gfx 2.10 GHz
- Memory: Installed RAM: 8 GB

System

- Windows 10 Home, version 21H2, build 19044.1415,
- Cygwin 3.3.3-1
- Many Cygwin packages, see cygcheck


## Files

- `README.md`: the present file
- `cygcheck-c-2022-01-08.txt`: output of `cygcheck -c`
- `config.log`
- `sagemath_doc_html-none.log`


## Session outline

Some checks

```
$ cygcheck -c cygwin
```

Some name choices

```
$ PROJECT=sage-9-5-b9-many
$ DATE=2022-01-08
$ THE_REPORT=slel-$DATE-cyg-$PROJECT
```

Create report folder

```
$ REPORTS=$HOME/sage-reports
$ REPORT=$REPORTS/$THE_REPORT
$ mkdir -p $REPORT
```

Create fresh readme possibly from template

```
$ touch $REPORT/README.md
$ rsync -a $REPORTS/reporting/template-report-README.md $REPORT/README.md
```

Some Cygwin package information

```
$ cygcheck -c > $REPORT/cygcheck-c-$DATE.txt
```

Clone Sage source, symlink to common upstream folder, check version

```
$ cd $HOME
$ git clone --single-branch --branch develop --tags -q sage.git $PROJECT
$ cd $PROJECT
$ ln -s $HOME/sage-upstream ./upstream
$ git branch -vv
```

Add vbraun as a remote

```
$ git remote add vbraun git://github.com/vbraun/sage.git -t develop
```

Fetch Volker Braun's develop branch

```
$ git fetch vbraun develop --tags -q
```

Create local vbraun branch

```
$ git switch -c vbraun vbraun/develop
```

Check what tickets were applied since the latest development release

```
$ git log --oneline --first-parent develop^..HEAD
```

Use short mirror list (avoid pinging other continents) and build

```
$ (cd upstream && cp mirror_list_short mirror_list && touch mirror_list)
$ export MAKE='make -j1'
$ ./bootstrap -q && ./configure && make -s V=0 testlong
```

Copy relevant logs to report folder

```
$ rsync -a config.log logs/install.log logs/pkgs/sagemath_doc_html-none.log $REPORT
```

Edit & proofread README, zip & upload report, and report to sage-release or Sage Trac

```
$ (cd $REPORTS && zip -r $THE_REPORT.zip $THE_REPORT)
$ rsync -a $THE_REPORT.zip me@example.com:www/sage/logs
```


## Session details

My bash is set up with `PS1='\n$ '` and `PS2='  '` for readability.

```
$ #   ===   PROJECT: Sage 9.5.beta9 plus many tickets closed since its release   ===

$ cygcheck -c cygwin
Cygwin Package Information
Package              Version        Status
cygwin               3.3.3-1        OK

$ PROJECT=sage-9-5-b9-many

$ DATE=2022-01-08

$ THE_REPORT=slel-$DATE-cyg-$PROJECT

$ REPORTS=$HOME/sage-reports

$ REPORT=$REPORTS/$THE_REPORT

$ mkdir -p $REPORT

$ rsync -a $REPORTS/reporting/template-report-README.md $REPORT/README.md

$ cygcheck -c > $REPORT/cygcheck-c-$DATE.txt

$ cd $HOME

$ git clone --single-branch --branch develop --tags -q sage.git $PROJECT
cd $PROJECT

$ cd $PROJECT

$ ln -s $HOME/sage-upstream ./upstream

$ git branch -vv
* develop c5af19568c [origin/develop] Updated SageMath version to 9.5.beta9

$ git remote add vbraun git://github.com/vbraun/sage.git -t develop

$ git fetch vbraun develop --tags -q

$ git switch -c vbraun vbraun/develop
Branch 'vbraun' set up to track remote branch 'develop' from 'vbraun'.
Switched to a new branch 'vbraun'

$ git log --oneline --first-parent develop^..HEAD
464e8c3d08 (HEAD -> vbraun, vbraun/develop) Trac #33104: Fix references to `doc-clean`
22001aa722 Trac #32759: ./configure --disable-doc
d5d2b5b0ed Trac #32860: Inaccurate documentation for number field elements_of_norm
e0ffa0f92d Trac #33097: some typos in combinat and modular
396023cf78 Trac #33087: build/bin/sage-clone-source: Use "trac" as name of the remote
771546ff82 Trac #33046: gap spkg creates absolute symlinks
be94896c70 Trac #32990: pickling support for real balls and related objects
81cc1a8156 Trac #32977: sage.features: Remove dependency on sage.misc.lazy_string
0cb2c8e457 Trac #32938: deactivation of the u-prefix doctest handler
c1f5a61578 Trac #32245: Quaternion ideals sometimes compare incorrectly
969746aadc Trac #30875: Random elements of AA aren't random
fe53f67ecd Trac #29784: Update section "Sage Development Process" in Developer's Guide
52f8223178 Trac #33080: Fix scipy-1.7.2 build failure on Cygwin
3bd8aedeb2 Trac #32868: configure tarball misses some generated files
283fef85db Trac #33036: random doctest failure in src/sage/crypto/util.py
b0b05d9493 Trac #32980: unmarked # long time tests in graphs/generators/classical_geometries.py
4990807a40 Trac #32972: Unmarked # long time tests in characteristic_cohomology_class.py
4929c5dd64 Trac #32971: unmarked # long time tests in ell_number_field.py
40a9c26056 Trac #30677: Add VS Code config for SAGE_ROOT/venv
e78700a067 Trac #33068: GH Actions: Remove ubuntu-groovy
1100bbaade Trac #33058: doctest in generic_graph.py can fail due to rounding error
7155edaef4 Trac #33019: remove more py2 or py3 tags in doctests
897e8e6d21 Trac #33031: add tolerance to is_hermitian() for sparse "double" matrices
7c823e63ad Trac #32904: Add version constraints for sage-conf, clean the sage-conf sdist
9fb5ea945f Trac #31672: Invalid latex repr from FreeAlgebra _latex_ / repr_lincomb
d6ac8199bc Trac #32062: GH Actions: Deploy sdists to PyPI
646bd9f4a8 Trac #33066: OpenSSL 3.0.1 security update
c4f76c053f Trac #32703: GH Actions (macOS): Run a job for "make build-local" first, cache image for job "make build"
039a909b6f Trac #32113: GH Actions: conda-forge tests broken
935315f002 Trac #30766: Experimental support for Python 3.10 in Sage 9.5
a34b9801ab Trac #33057: fix incorrect doctest in solve_integer of binary quadratic forms
3273e8aff6 Trac #33067: tox / GH Actions: Fix docker-based tests after #31386
bd2a8371f0 Trac #29039: pip-installable version of package sage_conf - installs non-Python bits of the Sage distribution in ~/.sage/
0cd457a745 Trac #33082: segfault: illegal (popcnt) instruction in primecount
cd124899d0 Trac #33073: Segmentation fault in face iterator (still)
da90b23cc9 Trac #29310: "make distclean" should not run "./configure"
c9093db43b Trac #13637: Add multiplicative order to complex interval field
fd0fbb9118 Trac #33040: Update matplotlib to 3.5
31d2b1c069 Trac #33012: Bug in bitset_copy_flex
02e8c4cca0 Trac #32676: logic.print_table changes your truthtable
c2810fce48 Trac #31580: Update matplotlib to 3.4
6fac484bc0 Trac #33060: pytest: Declare dependencies
599ced4e9f Trac #33059: conda-forge-macos-standard: pyzmq build fails
13a6210d75 Trac #33043: Upgrade: lcalc 2.0.5 to allow building on Cygwin
e39ff7d436 Trac #33042: givaro spkg-configure: Reject too new versions
2f510446d6 Trac #32907: Update singular to 4.2.1p3
c5af19568c (tag: 9.5.beta9, origin/develop, origin/HEAD, develop) Updated SageMath version to 9.5.beta9

$ (cd upstream && cp mirror_list_short mirror_list && touch mirror_list)

$ export MAKE='make -j1'

$ ./bootstrap -q && ./configure && make -s V=0 ptestlong
checking for a BSD-compatible install... /usr/bin/install -c
checking whether build environment is sane... yes
checking for a race-free mkdir -p... /usr/bin/mkdir -p
checking for gawk... gawk
checking whether make -j1 sets $(MAKE)... yes
checking whether make -j1 supports nested variables... yes
checking whether to enable maintainer-specific portions of Makefiles... yes
checking whether make -j1 supports the include directive... yes (GNU style)
checking for gcc... gcc
checking whether the C compiler works... yes
checking for C compiler default output file name... a.exe
checking for suffix of executables... .exe
checking whether we are cross compiling... no
checking for suffix of object files... o
checking whether the compiler supports GNU C... yes
checking whether gcc accepts -g... yes
checking for gcc option to enable C11 features... none needed
checking whether gcc understands -c and -o together... yes
checking dependency style of gcc... none
checking build system type... x86_64-pc-cygwin
checking host system type... x86_64-pc-cygwin
checking for ld used by gcc... /usr/x86_64-pc-cygwin/bin/ld.exe
checking if the linker (/usr/x86_64-pc-cygwin/bin/ld.exe) is GNU ld... yes
checking for shared library run path origin... done
checking for root user... no
checking for a sed that does not truncate output... /usr/bin/sed
checking for ar... yes
checking for m4... yes
checking for pkg-config... /usr/bin/pkg-config
checking pkg-config is at least version 0.29... yes
checking for ranlib... yes
checking for strip... yes
checking for GNU or BSD tar... /usr/bin/tar
checking for Python... /usr/bin/python
checking for latex... yes
checking for perl... /usr/bin/perl
checking for Perl version 5.8.0 or later... yes
checking whether a conda environment is active... no
checking for gcc... (cached) gcc
checking whether the compiler supports GNU C... (cached) yes
checking whether gcc accepts -g... (cached) yes
checking for gcc option to enable C11 features... (cached) none needed
checking whether gcc understands -c and -o together... (cached) yes
checking dependency style of gcc... (cached) none
checking how to run the C preprocessor... gcc -E
checking for g++... g++
checking whether the compiler supports GNU C++... yes
checking whether g++ accepts -g... yes
checking for g++ option to enable C++11 features... none needed
checking dependency style of g++... none
checking for gfortran... gfortran
checking whether the compiler supports GNU Fortran... yes
checking whether gfortran accepts -g... yes
checking for gcc... gcc
checking whether the compiler supports GNU Objective C... no
checking whether gcc accepts -g... no
checking dependency style of gcc... none
checking for g++... g++
checking whether the compiler supports GNU Objective C++... no
checking whether g++ accepts -g... no
checking dependency style of g++... none
checking for stdio.h... yes
checking for stdlib.h... yes
checking for string.h... yes
checking for inttypes.h... yes
checking for stdint.h... yes
checking for strings.h... yes
checking for sys/stat.h... yes
checking for sys/types.h... yes
checking for unistd.h... yes
checking for complex.h... yes
checking for sqrt in -lm... yes
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG gcc...
checking for C compiler vendor... gnu
checking whether g++ supports C++11 features with -std=gnu++11... yes
checking if gcc accepts -dumpversion option... yes
checking gcc version... 11
checking if g++ accepts -dumpversion option... yes
checking g++ version... 11
checking whether C++ compiler accepts "-march=native"... yes
checking for OpenMP flag of C compiler... -fopenmp
checking for OpenMP flag of C++ compiler... -fopenmp
configure: will use system package and not install SPKG gcc
checking for the location of crti.o...
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG _prereq...
configure: will use system package and not install SPKG _prereq
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG _recommended...
configure: no suitable system package found for SPKG _recommended
checking how to run the C++ preprocessor... g++ -std=gnu++11 -E
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG gmp...
checking for gmp.h... yes
checking for gmpxx.h... yes
checking for library containing __gmpq_cmp_z... -lgmp
configure: will use system package and not install SPKG gmp
checking absolute name of <gmp.h>... checking for gmp.h... (cached) yes
///usr/include/gmp.h
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG zlib...
checking for inflateEnd in -lz... yes
checking for zlib.h... yes
checking for LIBPNG... yes
configure: will use system package and not install SPKG zlib
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG glpk...
checking whether any of gmp zlib is installed as or will be installed as SPKG... no
checking for glpsol... /usr/bin/glpsol
checking for glpk.h... yes
checking for library containing glp_config... -lglpk
yes. Use system's glpk
configure: will use system package and not install SPKG glpk
using glpk from the system
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG 4ti2...
checking whether any of gmp glpk zlib is installed as or will be installed as SPKG... no
checking for hilbert... hilbert
checking for markov... markov
checking for graver... graver
checking for zsolve... zsolve
checking for qsolve... qsolve
checking for rays... rays
checking for ppi... ppi
checking for circuits... circuits
checking for groebner... groebner
checking for library 4ti2gmp... yes
configure: will use system package and not install SPKG 4ti2
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG tox...
checking for tox >= 2.5.0...
configure: no suitable system package found for SPKG tox
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG virtualenv...
configure: no suitable system package found for SPKG virtualenv
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG appdirs...
configure: no suitable system package found for SPKG appdirs
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG mpfr...
checking whether any of gmp is installed as or will be installed as SPKG... no
checking for mpfr.h... yes
checking for library containing mpfr_free_pool... -lmpfr
configure: will use system package and not install SPKG mpfr
using mpfr library from the system
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG ntl...
checking whether any of gmp gcc is installed as or will be installed as SPKG... no
checking for NTL/ZZ.h... yes
checking whether we can link a program using NTL... yes
checking NTL version >= 10.3... yes
configure: will use system package and not install SPKG ntl
checking absolute name of <NTL/ZZ.h>... checking for NTL/ZZ.h... (cached) yes
///usr/include/NTL/ZZ.h
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG flint...
checking whether any of mpfr ntl is installed as or will be installed as SPKG... no
checking for flint/flint.h... yes
checking for library containing fmpz_mod_ctx_init... -lflint
checking for library containing fmpz_poly_get_ZZX... none required
checking that GC is not enabled in Flint... ... GC not enabled. Good.
configure: will use system package and not install SPKG flint
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG arb...
checking installing flint? ... checking for arb.h... no
configure: no suitable system package found for SPKG arb
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG boost_cropped...
checking for boostlib >= 1.66.0 (106600)... yes
configure: will use system package and not install SPKG boost_cropped
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libpng...
checking installing zlib? ... no
checking for LIBPNG... yes
configure: will use system package and not install SPKG libpng
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG m4ri...
checking whether any of libpng is installed as or will be installed as SPKG... no
checking for M4RI... no
configure: no suitable system package found for SPKG m4ri
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG brial...
checking whether any of gcc boost_cropped m4ri is installed as or will be installed as SPKG... yes; install brial as well
configure: no suitable system package found for SPKG brial
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG bzip2...
checking for bzlib.h... yes
checking for library containing BZ2_bzCompress... -lbz2
checking for bzip2... /usr/bin/bzip2
configure: will use system package and not install SPKG bzip2
checking for Fortran flag needed to accept free-form source... -ffree-form
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG gfortran...
checking the version of gfortran... 11
configure: will use system package and not install SPKG gfortran
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG openblas...
checking whether any of gfortran is installed as or will be installed as SPKG... no
checking for OPENBLAS... no
no, test for OpenBLAS disabled on Cygwin
checking for library containing cblas_dgemm... -lcblas
checking for library containing dgeqrf... no
checking for library containing dgeqrf_... -llapack
checking for library containing DGEQRF... no
checking for library containing DGEQRF_... no
configure: no suitable system package found for SPKG openblas
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG cbc...
checking whether any of openblas zlib bzip2 is installed as or will be installed as SPKG... yes; install cbc as well
configure: no suitable system package found for SPKG cbc
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG cddlib...
checking whether any of gmp is installed as or will be installed as SPKG... no
checking for cddexec... cddexec
checking for cddexec_gmp... cddexec_gmp
checking for redcheck_gmp... redcheck_gmp
checking for scdd_gmp... scdd_gmp
checking whether cddexec --redcheck works correctly for real input... yes
checking for cddlib/cdd.h... yes
checking for library containing dd_abs... -lcddgmp
configure: will use system package and not install SPKG cddlib
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG cliquer...
checking for library containing clique_unweighted_max_weight... no
configure: no suitable system package found for SPKG cliquer
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG cmake...
checking for cmake >= 3.4... /usr/bin/cmake
configure: will use system package and not install SPKG cmake
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG coxeter3...
checking for library coxeter3... no
configure: no suitable system package found for SPKG coxeter3
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG curl...
checking for curl 7.22... /usr/bin/curl
checking for gawk... (cached) gawk
checking for curl-config... /usr/bin/curl-config
checking for the version of libcurl... 7.80.0
checking for libcurl >= version 7.22... yes
checking whether libcurl is usable... yes
checking for curl_free... yes
checking whether programs linking to libcurl can be executed... yes
configure: will use system package and not install SPKG curl
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG distlib...
configure: no suitable system package found for SPKG distlib
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libatomic_ops...
checking for LIBATOMIC_OPS... yes
configure: will use system package and not install SPKG libatomic_ops
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG gc...
checking whether any of libatomic_ops is installed as or will be installed as SPKG... no
checking whether we run on WSL... no
checking for GC... no
checking for GC... yes
configure: will use system package and not install SPKG gc
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG ecl...
checking whether any of gcc gc gmp is installed as or will be installed as SPKG... no
checking for ecl-config... no
configure: no suitable system package found for SPKG ecl
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG ncurses...
checking for NCURSES... yes
configure: will use system package and not install SPKG ncurses
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG readline...
checking Installing ncurses? ... No.
checking for READLINE... yes
configure: will use system package and not install SPKG readline
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pari...
checking whether any of gmp readline is installed as or will be installed as SPKG... no
checking for gp... no
configure: gp is not found
configure: no suitable system package found for SPKG pari
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG eclib...
checking whether any of ntl pari flint is installed as or will be installed as SPKG... yes; install eclib as well
configure: no suitable system package found for SPKG eclib
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG ecm...
checking whether any of gmp is installed as or will be installed as SPKG... no
checking for ecm.h... no
configure: no suitable system package found for SPKG ecm
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG givaro...
checking whether any of gmp is installed as or will be installed as SPKG... no
checking for givaro-config... no
configure: givaro-config not found. Installing givaro
configure: no suitable system package found for SPKG givaro
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG fflas_ffpack...
checking whether any of givaro gmp openblas is installed as or will be installed as SPKG... yes; install fflas_ffpack as well
configure: no suitable system package found for SPKG fflas_ffpack
checking whether C++ compiler accepts -mavx512f -mavx512vl -mavx512dq... yes
checking whether C++ compiler accepts -mfma... yes
checking whether C++ compiler accepts -mfma4... yes
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG ffmpeg...
checking for ffmpeg... no
configure: no suitable system package found for SPKG ffmpeg
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG filelock...
configure: no suitable system package found for SPKG filelock
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG flintqs...
checking for QuadraticSieve... no
configure: no suitable system package found for SPKG flintqs
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG fplll...
checking whether any of gcc mpfr is installed as or will be installed as SPKG... no
checking for FPLLL... no
configure: no suitable system package found for SPKG fplll
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG freetype...
checking whether any of gcc libpng is installed as or will be installed as SPKG... no
checking for FREETYPE... yes
configure: will use system package and not install SPKG freetype
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG gengetopt...
checking for gengetopt... /usr/bin/gengetopt
configure: will use system package and not install SPKG gengetopt
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG gf2x...
checking for GF2X... no
checking for gf2x.h... no
checking for library containing gf2x_mul_r... no
configure: no suitable system package found for SPKG gf2x
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG gfan...
checking for gfan >= 0.6.2...
configure: no suitable system package found for SPKG gfan
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG giac...
checking whether any of pari is installed as or will be installed as SPKG... yes; install giac as well
configure: no suitable system package found for SPKG giac
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG git...
checking for git... /usr/bin/git
configure: will use system package and not install SPKG git
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG gp2c...
checking whether any of pari is installed as or will be installed as SPKG... yes; install gp2c as well
configure: pari.cfg is $SAGE_LOCAL/lib/pari/pari.cfg
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG graphviz...
checking for dot... dot
checking for neato... neato
checking for twopi... twopi
configure: will use system package and not install SPKG graphviz
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG gsl...
checking whether any of openblas is installed as or will be installed as SPKG... yes; install gsl as well
configure: no suitable system package found for SPKG gsl
checking 32-bit host C ABI... no
checking for grep that handles long lines and -e... /usr/bin/grep
checking for egrep... /usr/bin/grep -E
checking for ELF binary format... no
checking for the common suffixes of directories in the library search path... lib,lib,lib
checking for iconv... yes
checking for working iconv... yes
checking how to link with libiconv... -liconv
checking for iconv declaration...
         extern size_t iconv (iconv_t cd, char * *inbuf, size_t *inbytesleft, char * *outbuf, size_t *outbytesleft);
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG iconv...
configure: will use system package and not install SPKG iconv
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG igraph...
checking whether any of glpk openblas gmp is installed as or will be installed as SPKG... yes; install igraph as well
configure: no suitable system package found for SPKG igraph
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG imagemagick...
checking for convert... /usr/bin/convert
configure: will use system package and not install SPKG imagemagick
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG iml...
checking whether any of gmp openblas is installed as or will be installed as SPKG... yes; install iml as well
configure: no suitable system package found for SPKG iml
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG info...
checking for info... /usr/bin/info
configure: will use system package and not install SPKG info
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG isl...
checking whether any of gmp is installed as or will be installed as SPKG... no
checking for ISL... yes
configure: will use system package and not install SPKG isl
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG lcalc...
checking whether any of pari is installed as or will be installed as SPKG... yes; install lcalc as well
configure: no suitable system package found for SPKG lcalc
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libbraiding...
checking if we can link against libbraiding... no
configure: no suitable system package found for SPKG libbraiding
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libffi...
checking for LIBFFI... yes
configure: will use system package and not install SPKG libffi
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libgd...
checking whether any of gcc libpng freetype is installed as or will be installed as SPKG... no
checking for LIBGD... yes
configure: will use system package and not install SPKG libgd
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libgraphviz...
checking for graphviz/cgraph.h... no
configure: no suitable system package found for SPKG libgraphviz
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libhomfly...
checking whether any of gc is installed as or will be installed as SPKG... no
checking for homfly.h... no
configure: no suitable system package found for SPKG libhomfly
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG xz...
configure: SPKG xz is not required on this system
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG liblzma...
checking whether any of xz is installed as or will be installed as SPKG... no
checking for lzma_raw_decoder in -llzma... yes
checking for lzma.h... yes
configure: will use system package and not install SPKG liblzma
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG nauty...
checking for geng... no
checking for nauty-geng... no
configure: no suitable system package found for SPKG nauty
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libnauty...
checking whether any of nauty is installed as or will be installed as SPKG... yes; install libnauty as well
configure: no suitable system package found for SPKG libnauty
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libsemigroups...
checking for LIBSEMIGROUPS... no
configure: no suitable system package found for SPKG libsemigroups
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG libxml2...
checking for xml2-config... /usr/bin/xml2-config
configure: will use system package and not install SPKG libxml2
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG llvm...
configure: will use system package and not install SPKG llvm
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG lrcalc...
checking for lrcalc/schublib.h... no
configure: no suitable system package found for SPKG lrcalc
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG lrslib...
checking whether any of gmp flint is installed as or will be installed as SPKG... no
checking for lrsnash... no
configure: no suitable system package found for SPKG lrslib
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG m4rie...
checking whether any of m4ri is installed as or will be installed as SPKG... yes; install m4rie as well
configure: no suitable system package found for SPKG m4rie
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG mpc...
checking whether any of mpfr is installed as or will be installed as SPKG... no
checking for mpc.h... yes
checking for library containing mpc_cmp_abs... -lmpc
configure: will use system package and not install SPKG mpc
using mpc library from the system
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG mpfi...
checking whether any of mpfr is installed as or will be installed as SPKG... no
checking for mpfi.h... no
checking for library containing mpfi_diam_abs... no
configure: no suitable system package found for SPKG mpfi
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG ninja_build...
checking for ninja >= 1.7.2... /usr/bin/ninja
configure: will use system package and not install SPKG ninja_build
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG python3...
checking whether any of bzip2 liblzma libffi is installed as or will be installed as SPKG... no
checking for python3 >= 3.7.0, < 3.11.0 with modules sqlite3, ctypes, math, hashlib, crypt, socket, zlib, distutils.core, ssl...
checking ... whether /usr/bin/python3 is good... yes
checking for python3 >= 3.7.0, < 3.11.0 with modules sqlite3, ctypes, math, hashlib, crypt, socket, zlib, distutils.core, ssl... /usr/bin/python3
configure: will use system package and not install SPKG python3
checking whether /usr/bin/python3 is configured to build multiarch extensions... no
checking whether "-march=native" works with the C/C++ compilers configured for building extensions for /usr/bin/python3... yes
checking whether OpenMP works with the C/C++ compilers configured for building extensions for /usr/bin/python3... yes
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG openssl...
configure: SPKG openssl is not required on this system
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG palp...
checking for poly.x... no
checking for poly-4d.x... no
checking for poly-5d.x... no
checking for poly-6d.x... no
checking for poly-11d.x... no
checking for class.x... no
checking for class-4d.x... no
checking for class-5d.x... no
checking for class-6d.x... no
checking for class-11d.x... no
checking for nef.x... no
checking for nef-4d.x... no
checking for nef-5d.x... no
checking for nef-6d.x... no
checking for nef-11d.x... no
checking for cws.x... no
checking for cws-4d.x... no
checking for cws-5d.x... no
checking for cws-6d.x... no
checking for cws-11d.x... no
configure: no suitable system package found for SPKG palp
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pandoc...
checking for pandoc... no
configure: no suitable system package found for SPKG pandoc
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pari_elldata...
checking installing pari? ... yes; install pari_elldata as well
configure: no suitable system package found for SPKG pari_elldata
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pari_galdata...
checking installing pari? ... yes; install pari_galdata as well
configure: no suitable system package found for SPKG pari_galdata
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pari_galpol...
checking installing pari? ... yes; install pari_galpol as well
configure: no suitable system package found for SPKG pari_galpol
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pari_nftables...
checking installing pari? ... yes; install pari_nftables as well
configure: no suitable system package found for SPKG pari_nftables
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pari_seadata...
checking installing pari? ... yes; install pari_seadata as well
configure: no suitable system package found for SPKG pari_seadata
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pari_seadata_small...
checking installing pari? ... yes; install pari_seadata_small as well
configure: no suitable system package found for SPKG pari_seadata_small
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG patch...
checking for GNU patch >= 2.7.0... /usr/bin/patch
configure: will use system package and not install SPKG patch
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pcre...
checking installing bzip2? ... no
checking for PCRE... yes
configure: will use system package and not install SPKG pcre
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pdf2svg...
checking for pdf2svg... no
configure: no suitable system package found for SPKG pdf2svg
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG perl_cpan_polymake_prereq...
checking for perl module XML::Writer... no
checking for perl module XML::LibXML... no
checking for perl module XML::LibXSLT... no
checking for perl module File::Slurp... no
checking for perl module JSON... no
checking for perl module SVG... no
checking for perl module Term::ReadKey... ok
configure: no suitable system package found for SPKG perl_cpan_polymake_prereq
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG perl_mongodb...
checking for perl module MongoDB... no
configure: no suitable system package found for SPKG perl_mongodb
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG perl_term_readline_gnu...
checking for perl module Term::ReadLine... ok
checking Term::ReadLine module...... GNU
configure: will use system package and not install SPKG perl_term_readline_gnu
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG pkgconf...
using pkg-config from the system
configure: will use system package and not install SPKG pkgconf
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG planarity...
checking for planarity/planarity.h... no
configure: no suitable system package found for SPKG planarity
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG polymake...
checking for polymake-config >= 3.5...
configure: no suitable system package found for SPKG polymake
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG ppl...
checking whether any of gcc glpk gmp is installed as or will be installed as SPKG... no
checking for ppl-config... no
checking for the Parma Polyhedra Library, version >= 1.2... no
*** The ppl-config script installed by PPL could not be found.
*** If the PPL was installed in PREFIX, make sure PREFIX/bin is in
*** your path, or set the PPL_CONFIG environment variable to the
*** full path to ppl-config.
configure: no suitable system package found for SPKG ppl
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG primesieve...
checking for PRIMESIEVE... no
configure: no suitable system package found for SPKG primesieve
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG primecount...
checking whether any of primesieve is installed as or will be installed as SPKG... yes; install primecount as well
configure: no suitable system package found for SPKG primecount
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG qhull...
checking for qhull... /usr/bin/qhull
checking is qhull's version good enough? ... yes.
checking is qhull_r library and headers installed? ... checking for libqhull_r/libqhull_r.h... yes
checking for library containing qh_distplane... -lqhull_r
yes. Use system's qhull
configure: will use system package and not install SPKG qhull
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG r...
checking whether any of openblas iconv readline bzip2 liblzma pcre curl is installed as or will be installed as SPKG... yes; install r as well
configure: no suitable system package found for SPKG r
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG rw...
checking for rw.h... no
checking for library containing calculate_level... no
configure: no suitable system package found for SPKG rw
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG singular...
checking whether any of gmp ntl flint readline mpfr cddlib is installed as or will be installed as SPKG... no
checking for Singular... /usr/bin/Singular
checking for SINGULAR... no
configure: no suitable system package found for SPKG singular
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG sqlite...
checking libsqlite3 >= sqlite3_min_version... yes
configure: will use system package and not install SPKG sqlite
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG suitesparse...
checking whether any of openblas is installed as or will be installed as SPKG... yes; install suitesparse as well
configure: no suitable system package found for SPKG suitesparse
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG symmetrica...
checking for symmetrica/def.h... no
configure: no suitable system package found for SPKG symmetrica
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG sympow...
checking for sympow... no
configure: no suitable system package found for SPKG sympow
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG tachyon...
checking for tachyon... no
configure: tachyon not found. Installing tachyon
configure: no suitable system package found for SPKG tachyon
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG toml...
configure: no suitable system package found for SPKG toml
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG zeromq...
checking whether any of gcc is installed as or will be installed as SPKG... no
checking for zmq.h... yes
checking for ZMQ version >= 4.2.5... no valid ZMQ version was found
configure: no suitable system package found for SPKG zeromq
-----------------------------------------------------------------------------
Checking whether SageMath should install SPKG zn_poly...
checking whether any of gmp is installed as or will be installed as SPKG... no
checking for zn_poly/zn_poly.h... no
configure: no suitable system package found for SPKG zn_poly
## ----------------------------------------------------------------------- ##
## Build status for each package:                                          ##
## ----------------------------------------------------------------------- ##
4ti2-1.6.7.p0:                               using system package; SPKG will not be installed
admcycles-none:                              optional pip package; use "./sage -i admcycles" to install
alabaster-0.7.12:                            standard, will be installed as an SPKG
appdirs-1.4.4:                               no suitable system package; standard, will be installed as an SPKG
appnope-0.1.2:                               standard, will be installed as an SPKG
arb-2.19.0.p0:                               no suitable system package; standard, will be installed as an SPKG
argcomplete-1.12.3:                          standard, will be installed as an SPKG
argon2_cffi-20.1.0:                          standard, will be installed as an SPKG
attrs-21.2.0:                                standard, will be installed as an SPKG
awali-1.0.2-190218:                          experimental, use "./configure --enable-awali" to install
babel-2.9.1:                                 standard, will be installed as an SPKG
backcall-0.2.0:                              standard, will be installed as an SPKG
barvinok-0.41.1:                             optional, use "./configure --enable-barvinok" to install
beautifulsoup4-none:                         optional pip package; use "./sage -i beautifulsoup4" to install
beniget-0.4.1:                               standard, will be installed as an SPKG
benzene-20130630:                            optional, use "./configure --enable-benzene" to install
biopython-none:                              optional pip package; use "./sage -i biopython" to install
bleach-4.1.0:                                standard, will be installed as an SPKG
bliss-0.73+debian-1+sage-2016-08-02.p0:      optional, use "./configure --enable-bliss" to install
boost_cropped-1.66.0.p0:                     using system package; SPKG will not be installed
brial-1.2.8:                                 no suitable system package; standard, will be installed as an SPKG
buckygen-1.1:                                optional, use "./configure --enable-buckygen" to install
bzip2-1.0.6-20150304.p0:                     using system package; SPKG will not be installed
cbc-2.9.4.p0:                                no suitable system package; optional, use "./configure --enable-cbc" to install
ccache-3.3.4:                                optional, use "./configure --enable-ccache" to install
cddlib-0.94m:                                using system package; SPKG will not be installed
certifi-2021.10.8:                           standard, will be installed as an SPKG
cffi-1.15.0:                                 standard, will be installed as an SPKG
charset_normalizer-2.0.4:                    standard, will be installed as an SPKG
cliquer-1.22:                                no suitable system package; standard, will be installed as an SPKG
cmake-3.21.0:                                using system package; SPKG will not be installed
cocoalib-0.99564:                            experimental, use "./configure --enable-cocoalib" to install
combinatorial_designs-20140630.p0:           standard, will be installed as an SPKG
configure-7c5ddd97148ade288dd7f8e8654aa8393f843004:came preinstalled with the SageMath tarball
conway_polynomials-0.5:                      standard, will be installed as an SPKG
coxeter3-8ac9c71723c8ca57a836d6381aed125261e44e9e.p0:no suitable system package; optional, use "./configure --enable-coxeter3" to install
cppy-1.1.0:                                  standard, will be installed as an SPKG
cryptominisat-5.6.8:                         optional, use "./configure --enable-cryptominisat" to install
csdp-6.2.p1:                                 optional, use "./configure --enable-csdp" to install
cunningham_tables-1.0:                       optional, use "./configure --enable-cunningham_tables" to install
curl-7.62.0.p0:                              using system package; SPKG will not be installed
cvxopt-1.2.7:                                standard, will be installed as an SPKG
cycler-0.11.0:                               standard, will be installed as an SPKG
cypari-2.1.2:                                standard, will be installed as an SPKG
cysignals-1.11.2:                            standard, will be installed as an SPKG
cython-0.29.24:                              standard, will be installed as an SPKG
d3js-3.4.8:                                  optional, use "./configure --enable-d3js" to install
database_cremona_ellcurve-20190911:          optional, use "./configure --enable-database_cremona_ellcurve" to install
database_jones_numfield-4:                   optional, use "./configure --enable-database_jones_numfield" to install
database_knotinfo-2021.10.1:                 optional, use "./configure --enable-database_knotinfo" to install
database_kohel-20160724:                     optional, use "./configure --enable-database_kohel" to install
database_mutation_class-1.0:                 optional, use "./configure --enable-database_mutation_class" to install
database_odlyzko_zeta-20061209:              optional, use "./configure --enable-database_odlyzko_zeta" to install
database_stein_watkins-20110713:             optional, use "./configure --enable-database_stein_watkins" to install
database_stein_watkins_mini-20070827:        optional, use "./configure --enable-database_stein_watkins_mini" to install
database_symbolic_data-20070206:             optional, use "./configure --enable-database_symbolic_data" to install
dateutil-2.8.2:                              standard, will be installed as an SPKG
debugpy-1.4.1:                               optional, use "./configure --enable-debugpy" to install
decorator-4.4.2:                             standard, will be installed as an SPKG
deformation-20210503:                        experimental, use "./configure --enable-deformation" to install
defusedxml-0.6.0:                            standard, will be installed as an SPKG
distlib-0.3.3:                               no suitable system package; standard, will be installed as an SPKG
docutils-0.17.1:                             standard, will be installed as an SPKG
dot2tex-2.11.3.p0:                           optional, use "./configure --enable-dot2tex" to install
e_antic-0.1.9:                               optional, use "./configure --enable-e_antic" to install
ecl-21.2.1:                                  no suitable system package; standard, will be installed as an SPKG
eclib-20210625:                              no suitable system package; standard, will be installed as an SPKG
ecm-7.0.4.p2:                                no suitable system package; standard, will be installed as an SPKG
elliptic_curves-0.8.1:                       standard, will be installed as an SPKG
entrypoints-0.3:                             standard, will be installed as an SPKG
fflas_ffpack-2.4.3.p0:                       no suitable system package; standard, will be installed as an SPKG
ffmpeg-none:                                 no suitable system package; optional
filelock-3.0.12:                             no suitable system package; standard, will be installed as an SPKG
flint-2.7.1.p0:                              using system package; SPKG will not be installed
flintqs-1.0.p0:                              no suitable system package; standard, will be installed as an SPKG
flit_core-3.4.0:                             standard, will be installed as an SPKG
fonttools-4.28.4:                            standard, will be installed as an SPKG
fplll-5.4.1:                                 no suitable system package; standard, will be installed as an SPKG
fpylll-0.5.6:                                standard, will be installed as an SPKG
freetype-2.10.4:                             using system package; SPKG will not be installed
fricas-1.3.7.p1:                             optional, use "./configure --enable-fricas" to install
frobby-0.9.0.p2:                             optional, use "./configure --enable-frobby" to install
gambit-15.1.1.p0:                            experimental, use "./configure --enable-gambit" to install
gap-4.11.1:                                  standard, will be installed as an SPKG
gap3-04jul17:                                experimental, use "./configure --enable-gap3" to install
gap_jupyter-0.9:                             optional, use "./configure --enable-gap_jupyter" to install
gap_packages-4.11.1:                         optional, use "./configure --enable-gap_packages" to install
gast-0.5.2:                                  standard, will be installed as an SPKG
gc-8.0.4:                                    using system package; SPKG will not be installed
gcc-10.3.0:                                  using system package; SPKG will not be installed
gdb-8.2:                                     experimental, use "./configure --enable-gdb" to install
gengetopt-2.23:                              using system package; SPKG will not be installed
gf2x-1.3.0:                                  no suitable system package; standard, will be installed as an SPKG
gfan-0.6.2.p1:                               no suitable system package; standard, will be installed as an SPKG
gfortran-10.3.0:                             using system package; SPKG will not be installed
giac-1.6.0.47p3:                             no suitable system package; standard, will be installed as an SPKG
git-none:                                    using system package
givaro-4.1.1:                                no suitable system package; standard, will be installed as an SPKG
glpk-5.0.p0:                                 using system package; SPKG will not be installed
glucose-4.1:                                 optional, use "./configure --enable-glucose" to install
gmp-6.2.1:                                   using system package; SPKG will not be installed
gmpy2-2.1.0rc1:                              standard, will be installed as an SPKG
gp2c-0.0.10.p0:                              no suitable system package; optional, use "./configure --enable-gp2c" to install
graphs-20210214.p0:                          standard, will be installed as an SPKG
graphviz-none:                               using system package
gsl-2.7:                                     no suitable system package; standard, will be installed as an SPKG
html5lib-1.1:                                standard, will be installed as an SPKG
iconv-1.15:                                  using system package; SPKG will not be installed
idna-3.2:                                    standard, will be installed as an SPKG
igraph-0.8.3:                                no suitable system package; optional, use "./configure --enable-igraph" to install
imagemagick-none:                            using system package
imagesize-1.2.0:                             standard, will be installed as an SPKG
iml-1.0.4p1.p2:                              no suitable system package; standard, will be installed as an SPKG
importlib_metadata-4.8.2:                    standard, will be installed as an SPKG
importlib_resources-5.2.2:                   standard, will be installed as an SPKG
info-6.8:                                    using system package; SPKG will not be installed
ipykernel-6.6.0:                             standard, will be installed as an SPKG
ipympl-0.7.0:                                optional, use "./configure --enable-ipympl" to install
ipython-7.29.0:                              standard, will be installed as an SPKG
ipython_genutils-0.2.0:                      standard, will be installed as an SPKG
ipywidgets-7.6.5:                            standard, will be installed as an SPKG
isl-0.20:                                    using system package; SPKG will not be installed
jedi-0.18.1:                                 standard, will be installed as an SPKG
jinja2-2.11.2:                               standard, will be installed as an SPKG
jmol-14.29.52:                               standard, will be installed as an SPKG
jsonschema-3.2.0:                            standard, will be installed as an SPKG
jupymake-0.9:                                optional, use "./configure --enable-jupymake" to install
jupyter_client-7.1.0:                        standard, will be installed as an SPKG
jupyter_core-4.9.1:                          standard, will be installed as an SPKG
jupyter_jsmol-0.2.4:                         standard, will be installed as an SPKG
jupyter_packaging-0.7.12:                    optional, use "./configure --enable-jupyter_packaging" to install
jupyterlab-none:                             optional pip package; use "./sage -i jupyterlab" to install
jupyterlab_pygments-0.1.2:                   standard, will be installed as an SPKG
jupyterlab_widgets-2.0:                      optional, use "./configure --enable-jupyterlab_widgets" to install
kenzo-1.1.10:                                optional, use "./configure --enable-kenzo" to install
kiwisolver-1.3.2:                            standard, will be installed as an SPKG
latte_int-1.7.6:                             optional, use "./configure --enable-latte_int" to install
lcalc-2.0.5:                                 no suitable system package; standard, will be installed as an SPKG
libatomic_ops-7.6.10:                        using system package; SPKG will not be installed
libbraiding-1.1:                             no suitable system package; standard, will be installed as an SPKG
libffi-3.2.1:                                using system package; SPKG will not be installed
libgd-2.3.2:                                 using system package; SPKG will not be installed
libgraphviz-none:                            no suitable system package; optional
libhomfly-1.02r6:                            no suitable system package; standard, will be installed as an SPKG
liblzma-5.2.5:                               using system package; SPKG will not be installed
libnauty-none:                               no suitable system package; optional, use "./configure --enable-libnauty" to install
libogg-1.3.1.p0:                             optional, use "./configure --enable-libogg" to install
libpng-1.6.29.p1:                            using system package; SPKG will not be installed
libsemigroups-1.1.0:                         no suitable system package; optional, use "./configure --enable-libsemigroups" to install
libtheora-1.1.1:                             experimental, use "./configure --enable-libtheora" to install
libxml2-none:                                using system package
lidia-2.3.0+latte-patches-2019-05-02:        optional, use "./configure --enable-lidia" to install
lie-2.2.2:                                   experimental, use "./configure --enable-lie" to install
linbox-1.6.3.p1:                             standard, will be installed as an SPKG
llvm-none:                                   not required on your platform
lrcalc-1.2.p1:                               no suitable system package; standard, will be installed as an SPKG
lrslib-071b+autotools-2021-07-13:            no suitable system package; optional, use "./configure --enable-lrslib" to install
m4ri-20200115:                               no suitable system package; standard, will be installed as an SPKG
m4rie-20200115:                              no suitable system package; standard, will be installed as an SPKG
markupsafe-1.1.1:                            standard, will be installed as an SPKG
mathics-4.0.0:                               optional, use "./configure --enable-mathics" to install
mathics_scanner-1.2.4:                       optional, use "./configure --enable-mathics_scanner" to install
mathjax-2.7.4.p0:                            standard, will be installed as an SPKG
matplotlib-3.5.1:                            standard, will be installed as an SPKG
matplotlib_inline-0.1.2:                     standard, will be installed as an SPKG
maxima-5.45.0.p0:                            standard, will be installed as an SPKG
mcqd-1.0.p0:                                 optional, use "./configure --enable-mcqd" to install
meataxe-1.0.1:                               optional, use "./configure --enable-meataxe" to install
memory_allocator-0.1.1:                      standard, will be installed as an SPKG
mistune-0.8.4:                               standard, will be installed as an SPKG
modular_decomposition-20100607:              experimental, use "./configure --enable-modular_decomposition" to install
mpc-1.1.0:                                   using system package; SPKG will not be installed
mpfi-1.5.2:                                  no suitable system package; standard, will be installed as an SPKG
mpfr-4.0.1.p0:                               using system package; SPKG will not be installed
mpfrcx-0.5:                                  optional, use "./configure --enable-mpfrcx" to install
mpmath-1.2.1:                                standard, will be installed as an SPKG
nauty-27r1.p1:                               no suitable system package; standard, will be installed as an SPKG
nbclient-0.5.9:                              standard, will be installed as an SPKG
nbconvert-6.1.0:                             standard, will be installed as an SPKG
nbformat-5.1.3:                              standard, will be installed as an SPKG
ncurses-6.0.p0:                              using system package; SPKG will not be installed
nest_asyncio-1.5.1:                          standard, will be installed as an SPKG
networkx-2.6.3:                              standard, will be installed as an SPKG
nibabel-none:                                optional pip package; use "./sage -i nibabel" to install
ninja_build-1.8.2:                           using system package; SPKG will not be installed
nodeenv-none:                                optional pip package; use "./sage -i nodeenv" to install
nodejs-12.18.3:                              optional, use "./configure --enable-nodejs" to install
normaliz-3.8.10:                             optional, use "./configure --enable-normaliz" to install
notebook-6.4.6:                              standard, will be installed as an SPKG
notedown-1.5.1:                              optional, use "./configure --enable-notedown" to install
ntl-11.4.3:                                  using system package; SPKG will not be installed
numpy-1.21.4:                                standard, will be installed as an SPKG
openblas-0.3.18:                             no suitable system package; standard, will be installed as an SPKG
openssl-3.0.1:                               not required on your platform; SPKG will not be installed
ore_algebra-none:                            optional pip package; use "./sage -i ore_algebra" to install
p_group_cohomology-3.3.2:                    optional, use "./configure --enable-p_group_cohomology" to install
packaging-21.0:                              standard, will be installed as an SPKG
palettable-3.3.0:                            optional, use "./configure --enable-palettable" to install
palp-2.11:                                   no suitable system package; standard, will be installed as an SPKG
pandoc-none:                                 no suitable system package; optional
pandoc_attributes-8bc82f6d:                  optional, use "./configure --enable-pandoc_attributes" to install
pandocfilters-1.4.3:                         standard, will be installed as an SPKG
pari-2.13.3:                                 no suitable system package; standard, will be installed as an SPKG
pari_elldata-20161017:                       no suitable system package; optional, use "./configure --enable-pari_elldata" to install
pari_galdata-20080411.p0:                    no suitable system package; standard, will be installed as an SPKG
pari_galpol-20180625:                        no suitable system package; optional, use "./configure --enable-pari_galpol" to install
pari_nftables-20080929:                      no suitable system package; optional, use "./configure --enable-pari_nftables" to install
pari_seadata-20090618:                       no suitable system package; optional, use "./configure --enable-pari_seadata" to install
pari_seadata_small-20090618.p0:              no suitable system package; standard, will be installed as an SPKG
parso-0.8.2:                                 standard, will be installed as an SPKG
patch-2.7.5:                                 using system package; SPKG will not be installed
pcre-8.40.p2:                                using system package; SPKG will not be installed
pdf2svg-none:                                no suitable system package; optional
perl_cpan_polymake_prereq-none:              no suitable system package; optional
perl_mongodb-none:                           no suitable system package; optional
perl_term_readline_gnu-1.35:                 using system package; SPKG will not be installed
pexpect-4.8.0:                               standard, will be installed as an SPKG
pickleshare-0.7.5:                           standard, will be installed as an SPKG
pillow-8.4.0:                                standard, will be installed as an SPKG
pint-0.17:                                   optional, use "./configure --enable-pint" to install
pip-21.3.1:                                  standard, will be installed as an SPKG
pkgconf-0.9.7.p2:                            using system package; SPKG will not be installed
pkgconfig-1.5.5:                             standard, will be installed as an SPKG
planarity-3.0.1.0:                           no suitable system package; standard, will be installed as an SPKG
plantri-4.5:                                 optional, use "./configure --enable-plantri" to install
pluggy-1.0.0:                                standard, will be installed as an SPKG
ply-3.11:                                    standard, will be installed as an SPKG
polylib-5.22.5:                              optional, use "./configure --enable-polylib" to install
polymake-4.5:                                no suitable system package; optional, use "./configure --enable-polymake" to install
polytopes_db-20170220.p0:                    standard, will be installed as an SPKG
polytopes_db_4d-1.0:                         optional, use "./configure --enable-polytopes_db_4d" to install
ppl-1.2.p1:                                  no suitable system package; standard, will be installed as an SPKG
pplpy-0.8.6:                                 standard, will be installed as an SPKG
pplpy_doc-0.8.6:                             standard, will be installed as an SPKG
primecount-7.1:                              no suitable system package; standard, will be installed as an SPKG
primecountpy-0.1.0:                          standard, will be installed as an SPKG
primesieve-7.6:                              no suitable system package; standard, will be installed as an SPKG
prometheus_client-0.11.0:                    standard, will be installed as an SPKG
prompt_toolkit-3.0.22:                       standard, will be installed as an SPKG
ptyprocess-0.5.1.p0:                         standard, will be installed as an SPKG
py-1.10.0:                                   standard, will be installed as an SPKG
pybind11-2.8.1:                              standard, will be installed as an SPKG
pybtex-none:                                 optional pip package; use "./sage -i pybtex" to install
pycosat-0.6.3:                               optional, use "./configure --enable-pycosat" to install
pycparser-2.20:                              standard, will be installed as an SPKG
pycygwin-0.1:                                standard, will be installed as an SPKG
pyflakes-none:                               optional pip package; use "./sage -i pyflakes" to install
pygments-2.10.0:                             standard, will be installed as an SPKG
pygraphviz-none:                             optional pip package; use "./sage -i pygraphviz" to install
pynormaliz-2.14:                             optional, use "./configure --enable-pynormaliz" to install
pyparsing-3.0.6:                             standard, will be installed as an SPKG
pyrsistent-0.18.0:                           standard, will be installed as an SPKG
pysingular-0.9.7:                            optional, use "./configure --enable-pysingular" to install
pytest-none:                                 optional pip package; use "./sage -i pytest" to install
python3-3.9.9:                               using system package; SPKG will not be installed
python_igraph-0.8.3:                         optional, use "./configure --enable-python_igraph" to install
pythran-0.10.0:                              standard, will be installed as an SPKG
pytz-2021.3:                                 standard, will be installed as an SPKG
pyx-none:                                    optional pip package; use "./sage -i pyx" to install
pyzmq-22.3.0:                                standard, will be installed as an SPKG
qepcad-B.1.72:                               experimental, use "./configure --enable-qepcad" to install
qhull-2020-src-8.0.2:                        using system package; SPKG will not be installed
r-3.6.3:                                     no suitable system package; standard, will be installed as an SPKG
r_jupyter-none:                              optional, use "./configure --enable-r_jupyter" to install
ratpoints-2.1.3.p5:                          standard, will be installed as an SPKG
readline-8.0:                                using system package; SPKG will not be installed
requests-2.26.0:                             standard, will be installed as an SPKG
rpy2-3.3.6:                                  standard, will be installed as an SPKG
rst2ipynb-0.2.3:                             optional, use "./configure --enable-rst2ipynb" to install
rubiks-20070912.p21:                         optional, use "./configure --enable-rubiks" to install
rw-0.9:                                      no suitable system package; standard, will be installed as an SPKG
saclib-2.2.7:                                optional, use "./configure --enable-saclib" to install
sage_conf-9.5.beta9:                         standard, will be installed as an SPKG
sage_docbuild-9.5.beta9:                     standard, will be installed as an SPKG
sage_flatsurf-none:                          optional pip package; use "./sage -i sage_flatsurf" to install
sage_numerical_backends_coin-9.0b12:         optional, use "./configure --enable-sage_numerical_backends_coin" to install
sage_numerical_backends_cplex-9.0b12:        optional, use "./configure --enable-sage_numerical_backends_cplex" to install
sage_numerical_backends_gurobi-9.3.1:        optional, use "./configure --enable-sage_numerical_backends_gurobi" to install
sage_setup-9.5.beta9:                        standard, will be installed as an SPKG
sage_sws2rst-9.5.beta9:                      optional, use "./configure --enable-sage_sws2rst" to install
sagelib-9.5.beta9:                           standard, will be installed as an SPKG
sagemath_doc_html-none:                      standard, will be installed as an SPKG
sagemath_doc_pdf-none:                       optional, use "./configure --enable-sagemath_doc_pdf" to install
sagenb_export-3.3:                           standard, will be installed as an SPKG
sagetex-3.5:                                 standard, will be installed as an SPKG
scipoptsuite-5.0.1:                          experimental, use "./configure --enable-scipoptsuite" to install
scipy-1.7.2:                                 standard, will be installed as an SPKG
send2trash-1.8.0:                            standard, will be installed as an SPKG
setuptools-59.2.0:                           standard, will be installed as an SPKG
setuptools_scm-6.3.2:                        standard, will be installed as an SPKG
setuptools_scm_git_archive-1.1:              standard, will be installed as an SPKG
setuptools_wheel-59.2.0:                     standard, will be installed as an SPKG
simplegeneric-0.8.1.p0:                      standard, will be installed as an SPKG
singular-4.2.1p3:                            no suitable system package; standard, will be installed as an SPKG
singular_jupyter-0.9.7:                      optional, use "./configure --enable-singular_jupyter" to install
sip-4.18:                                    optional, use "./configure --enable-sip" to install
sirocco-2.1.0:                               optional, use "./configure --enable-sirocco" to install
six-1.16.0:                                  standard, will be installed as an SPKG
slabbe-none:                                 optional pip package; use "./sage -i slabbe" to install
snappy-none:                                 optional pip package; use "./sage -i snappy" to install
snowballstemmer-2.1.0:                       standard, will be installed as an SPKG
speaklater-1.3.p0:                           optional, use "./configure --enable-speaklater" to install
sphinx-4.2.0:                                standard, will be installed as an SPKG
sphinxcontrib_applehelp-1.0.2:               standard, will be installed as an SPKG
sphinxcontrib_devhelp-1.0.2:                 standard, will be installed as an SPKG
sphinxcontrib_htmlhelp-2.0.0:                standard, will be installed as an SPKG
sphinxcontrib_jsmath-1.0.1:                  standard, will be installed as an SPKG
sphinxcontrib_qthelp-1.0.3:                  standard, will be installed as an SPKG
sphinxcontrib_serializinghtml-1.1.5:         standard, will be installed as an SPKG
sphinxcontrib_websupport-1.2.1:              standard, will be installed as an SPKG
sqlalchemy-none:                             optional pip package; use "./sage -i sqlalchemy" to install
sqlite-3.36.0:                               using system package; SPKG will not be installed
suitesparse-5.10.1:                          no suitable system package; standard, will be installed as an SPKG
surf-1.0.6-gcc6:                             experimental, use "./configure --enable-surf" to install
surface_dynamics-none:                       optional pip package; use "./sage -i surface_dynamics" to install
symengine-0.8.1:                             optional, use "./configure --enable-symengine" to install
symengine_py-0.8.1.p0:                       optional, use "./configure --enable-symengine_py" to install
symmetrica-3.0.1:                            no suitable system package; standard, will be installed as an SPKG
sympow-2.023.6:                              no suitable system package; standard, will be installed as an SPKG
sympy-1.9:                                   standard, will be installed as an SPKG
tachyon-0.98.9.p7:                           no suitable system package; standard, will be installed as an SPKG
tdlib-0.3.1.p0:                              optional, use "./configure --enable-tdlib" to install
terminado-0.12.1:                            standard, will be installed as an SPKG
testpath-0.5.0:                              standard, will be installed as an SPKG
texlive-none:                                optional, use "./configure --enable-texlive" to install
texttable-1.6.3:                             optional, use "./configure --enable-texttable" to install
thebe-9624e0a0.p0:                           standard, will be installed as an SPKG
threejs-r122.p0:                             standard, will be installed as an SPKG
tides-2.0.p0:                                optional, use "./configure --enable-tides" to install
toml-0.10.2:                                 no suitable system package; standard, will be installed as an SPKG
tomli-1.2.1:                                 standard, will be installed as an SPKG
topcom-0.17.7:                               optional, use "./configure --enable-topcom" to install
tornado-6.1:                                 standard, will be installed as an SPKG
tox-3.24.3:                                  no suitable system package; standard, will be installed as an SPKG
traitlets-5.1.1:                             standard, will be installed as an SPKG
typing_extensions-3.10.0.0:                  standard, will be installed as an SPKG
tzlocal-2.1:                                 standard, will be installed as an SPKG
urllib3-1.26.6:                              standard, will be installed as an SPKG
valgrind-3.14.0:                             experimental, use "./configure --enable-valgrind" to install
vcversioner-2.16.0.0.p0:                     standard, will be installed as an SPKG
virtualenv-20.7.2:                           no suitable system package; standard, will be installed as an SPKG
wcwidth-0.2.5:                               standard, will be installed as an SPKG
webencodings-0.5.1:                          standard, will be installed as an SPKG
wheel-0.37.0:                                standard, will be installed as an SPKG
widgetsnbextension-3.5.2:                    standard, will be installed as an SPKG
xz-5.2.5:                                    not required on your platform; SPKG will not be installed
zeromq-4.3.4:                                no suitable system package; standard, will be installed as an SPKG
zipp-3.5.0:                                  standard, will be installed as an SPKG
zlib-1.2.11.p0:                              using system package; SPKG will not be installed
zn_poly-0.9.2:                               no suitable system package; standard, will be installed as an SPKG
checking that generated files are newer than configure... done
configure: creating ./config.status
config.status: creating build/make/Makefile-auto
config.status: creating build/make/Makefile
config.status: creating src/bin/sage-env-config
config.status: creating src/bin/sage-src-env-config
config.status: creating build/bin/sage-build-env-config
config.status: creating pkgs/sage-conf/sage_conf.py
config.status: creating pkgs/sage-conf/setup.cfg
config.status: executing depfiles commands
config.status: executing mkdirs commands
config.status: creating directory /home/s/sage-9-5-b9-many/logs/pkgs
config.status: creating directory local
config.status: creating directory local/bin
config.status: creating directory local/etc
config.status: creating directory local/include
config.status: creating directory local/lib
config.status: creating directory local/lib/pkgconfig
config.status: creating directory local/share
config.status: creating directory local/var/lib/sage/installed
config.status: creating symbolic link lib64 -> lib
config.status: executing links commands
config.status: creating convenience symlink prefix -> local
config.status: creating convenience symlink venv -> local/var/lib/sage/venv-python3.9
configure:

    notice: the following SPKGs did not find equivalent system packages:

        appdirs arb brial cliquer distlib ecl eclib ecm fflas_ffpack filelock flintqs fplll gf2x gfan giac givaro gsl iml lcalc libbraiding libhomfly lrcalc m4ri m4rie mpfi nauty openblas palp pari pari_galdata pari_seadata_small planarity ppl primecount primesieve r rw singular suitesparse symmetrica sympow tachyon toml tox virtualenv zeromq zn_poly   _recommended cbc coxeter3 ffmpeg gp2c igraph libgraphviz libnauty libsemigroups lrslib pandoc pari_elldata pari_galpol pari_nftables pari_seadata pdf2svg perl_cpan_polymake_prereq perl_mongodb polymake

checking for the package system in use... cygwin
configure:

    hint: installing the following system packages, if not
    already present, is recommended and may avoid having to
    build them (though some may have to be built anyway):

    first install apt-cyg from https://github.com/transcode-open/apt-cyg
      $ apt-cyg install libgsl-devel liblapack-devel libopenblas R libtirpc-devel singular-devel singular libsuitesparseconfig-devel tox libzmq-devel

configure:

    hint: installing the following system packages, if not
    already present, may provide additional optional features:

    first install apt-cyg from https://github.com/transcode-open/apt-cyg
      $ apt-cyg install graphviz

configure:

    hint: After installation, re-run configure using:

      $ ./config.status --recheck && ./config.status

*** ALL ENVIRONMENT VARIABLES BEFORE BUILD: ***
!::=::\
_=/usr/bin/env
ALLUSERSPROFILE=C:\ProgramData
APPDATA=C:\Users\s\AppData\Roaming
CommonProgramFiles(x86)=C:\Program Files (x86)\Common Files
COMMONPROGRAMFILES=C:\Program Files\Common Files
CommonProgramW6432=C:\Program Files\Common Files
COMPUTERNAME=LAPTOP-Q6AFHV1S
COMSPEC=C:\WINDOWS\system32\cmd.exe
DriverData=C:\Windows\System32\Drivers\DriverData
EXECIGNORE=*.dll
FPS_BROWSER_APP_PROFILE_STRING=Internet Explorer
FPS_BROWSER_USER_PROFILE_STRING=Default
HOME=/home/s
HOMEDRIVE=C:
HOMEPATH=\Users\s
HOSTNAME=Uc
INFOPATH=/usr/local/info:/usr/share/info:/usr/info
LANG=en_US.utf8
LANGUAGE=en_US.utf8
LC_ALL=en_US.utf8
LC_CTYPE=en_US.utf8
LOCALAPPDATA=C:\Users\s\AppData\Local
LOGONSERVER=\\LAPTOP-Q6AFHV1S
MAKE_TERMERR=/dev/pty0
MAKE_TERMOUT=/dev/pty0
MAKE=make -j1
MAKEFLAGS=s -- V=0 V=1
MAKELEVEL=1
MAKEOVERRIDES=${-*-command-variables-*-}
MFLAGS=-s
MINTTY_SHORTCUT=/cygdrive/c/Users/s/AppData/Roaming/Microsoft/Internet Explorer/Quick Launch/User Pinned/TaskBar/Cygwin64 Terminal.lnk
NUMBER_OF_PROCESSORS=8
OLDPWD=/home/s/sage-9-5-b9-many
OneDrive=C:\Users\s\OneDrive
ORIGINAL_PATH=/cygdrive/c/WINDOWS/system32:/cygdrive/c/WINDOWS:/cygdrive/c/WINDOWS/System32/Wbem:/cygdrive/c/WINDOWS/System32/WindowsPowerShell/v1.0:/cygdrive/c/WINDOWS/System32/OpenSSH:/cygdrive/c/Users/s/AppData/Local/Microsoft/WindowsApps
OS=Windows_NT
PATH=/home/s/sage-9-5-b9-many/build/bin:/home/s/sage-9-5-b9-many/src/bin:/home/s/sage-9-5-b9-many/local/bin:/usr/local/bin:/usr/bin:/cygdrive/c/WINDOWS/system32:/cygdrive/c/WINDOWS:/cygdrive/c/WINDOWS/System32/Wbem:/cygdrive/c/WINDOWS/System32/WindowsPowerShell/v1.0:/cygdrive/c/WINDOWS/System32/OpenSSH:/cygdrive/c/Users/s/AppData/Local/Microsoft/WindowsApps:/usr/lib/lapack
PATHEXT=.COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC
PRINTER=Microsoft Print to PDF
PROCESSOR_ARCHITECTURE=AMD64
PROCESSOR_IDENTIFIER=AMD64 Family 23 Model 24 Stepping 1, AuthenticAMD
PROCESSOR_LEVEL=23
PROCESSOR_REVISION=1801
PROFILEREAD=true
ProgramData=C:\ProgramData
ProgramFiles(x86)=C:\Program Files (x86)
PROGRAMFILES=C:\Program Files
ProgramW6432=C:\Program Files
PSModulePath=C:\Program Files\WindowsPowerShell\Modules;C:\WINDOWS\system32\WindowsPowerShell\v1.0\Modules
PUBLIC=C:\Users\Public
PWD=/home/s/sage-9-5-b9-many/build/make
PYTHONPATH=/home/s/sage-9-5-b9-many/local
SAGE_ENV_CONFIG_SOURCED=1
SAGE_LOCAL=/home/s/sage-9-5-b9-many/local
SAGE_LOGFILE=logs/install.log
SAGE_LOGS=/home/s/sage-9-5-b9-many/logs/pkgs
SAGE_NUM_THREADS_PARALLEL=1
SAGE_NUM_THREADS=1
SAGE_ORIG_PATH_SET=True
SAGE_ORIG_PATH=/usr/local/bin:/usr/bin:/cygdrive/c/WINDOWS/system32:/cygdrive/c/WINDOWS:/cygdrive/c/WINDOWS/System32/Wbem:/cygdrive/c/WINDOWS/System32/WindowsPowerShell/v1.0:/cygdrive/c/WINDOWS/System32/OpenSSH:/cygdrive/c/Users/s/AppData/Local/Microsoft/WindowsApps:/usr/lib/lapack
SAGE_PKGCONFIG=/home/s/sage-9-5-b9-many/local/lib/pkgconfig
SAGE_ROOT=/home/s/sage-9-5-b9-many
SAGE_SHARE=/home/s/sage-9-5-b9-many/local/share
SAGE_SILENT_BUILD=yes
SAGE_SRC=/home/s/sage-9-5-b9-many/src
SESSIONNAME=Console
SHELL=/bin/bash
SHLVL=4
SYSTEMDRIVE=C:
SYSTEMROOT=C:\WINDOWS
TEMP=/tmp
TERM_PROGRAM_VERSION=3.5.2
TERM_PROGRAM=mintty
TERM=xterm
TMP=/tmp
TZ=Europe/Paris
USER=s
USERDOMAIN_ROAMINGPROFILE=LAPTOP-Q6AFHV1S
USERDOMAIN=LAPTOP-Q6AFHV1S
USERNAME=s
USERPROFILE=C:\Users\s
V=0
WINDIR=C:\WINDOWS
***********************************************

real    0m0.270s
user    0m0.107s
sys     0m0.168s
Sage build/upgrade complete!
*** ALL ENVIRONMENT VARIABLES BEFORE BUILD: ***
!::=::\
_=/usr/bin/env
ALLUSERSPROFILE=C:\ProgramData
APPDATA=C:\Users\s\AppData\Roaming
CommonProgramFiles(x86)=C:\Program Files (x86)\Common Files
COMMONPROGRAMFILES=C:\Program Files\Common Files
CommonProgramW6432=C:\Program Files\Common Files
COMPUTERNAME=LAPTOP-Q6AFHV1S
COMSPEC=C:\WINDOWS\system32\cmd.exe
DriverData=C:\Windows\System32\Drivers\DriverData
EXECIGNORE=*.dll
FPS_BROWSER_APP_PROFILE_STRING=Internet Explorer
FPS_BROWSER_USER_PROFILE_STRING=Default
HOME=/home/s
HOMEDRIVE=C:
HOMEPATH=\Users\s
HOSTNAME=Uc
INFOPATH=/usr/local/info:/usr/share/info:/usr/info
LANG=en_US.utf8
LANGUAGE=en_US.utf8
LC_ALL=en_US.utf8
LC_CTYPE=en_US.utf8
LOCALAPPDATA=C:\Users\s\AppData\Local
LOGONSERVER=\\LAPTOP-Q6AFHV1S
MAKE_TERMERR=/dev/pty0
MAKE_TERMOUT=/dev/pty0
MAKE=make -j1
MAKEFLAGS=s -j1 -- V=0 V=1
MAKELEVEL=2
MAKEOVERRIDES=${-*-command-variables-*-}
MFLAGS=-s -j1
MINTTY_SHORTCUT=/cygdrive/c/Users/s/AppData/Roaming/Microsoft/Internet Explorer/Quick Launch/User Pinned/TaskBar/Cygwin64 Terminal.lnk
NUMBER_OF_PROCESSORS=8
OLDPWD=/home/s/sage-9-5-b9-many
OneDrive=C:\Users\s\OneDrive
ORIGINAL_PATH=/cygdrive/c/WINDOWS/system32:/cygdrive/c/WINDOWS:/cygdrive/c/WINDOWS/System32/Wbem:/cygdrive/c/WINDOWS/System32/WindowsPowerShell/v1.0:/cygdrive/c/WINDOWS/System32/OpenSSH:/cygdrive/c/Users/s/AppData/Local/Microsoft/WindowsApps
OS=Windows_NT
PATH=/home/s/sage-9-5-b9-many/build/bin:/home/s/sage-9-5-b9-many/src/bin:/home/s/sage-9-5-b9-many/local/bin:/usr/local/bin:/usr/bin:/cygdrive/c/WINDOWS/system32:/cygdrive/c/WINDOWS:/cygdrive/c/WINDOWS/System32/Wbem:/cygdrive/c/WINDOWS/System32/WindowsPowerShell/v1.0:/cygdrive/c/WINDOWS/System32/OpenSSH:/cygdrive/c/Users/s/AppData/Local/Microsoft/WindowsApps:/usr/lib/lapack
PATHEXT=.COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC
PRINTER=Microsoft Print to PDF
PROCESSOR_ARCHITECTURE=AMD64
PROCESSOR_IDENTIFIER=AMD64 Family 23 Model 24 Stepping 1, AuthenticAMD
PROCESSOR_LEVEL=23
PROCESSOR_REVISION=1801
PROFILEREAD=true
ProgramData=C:\ProgramData
ProgramFiles(x86)=C:\Program Files (x86)
PROGRAMFILES=C:\Program Files
ProgramW6432=C:\Program Files
PSModulePath=C:\Program Files\WindowsPowerShell\Modules;C:\WINDOWS\system32\WindowsPowerShell\v1.0\Modules
PUBLIC=C:\Users\Public
PWD=/home/s/sage-9-5-b9-many/build/make
PYTHONPATH=/home/s/sage-9-5-b9-many/local
SAGE_ENV_CONFIG_SOURCED=1
SAGE_LOCAL=/home/s/sage-9-5-b9-many/local
SAGE_LOGFILE=logs/install.log
SAGE_LOGS=/home/s/sage-9-5-b9-many/logs/pkgs
SAGE_NUM_THREADS_PARALLEL=1
SAGE_NUM_THREADS=1
SAGE_ORIG_PATH_SET=True
SAGE_ORIG_PATH=/usr/local/bin:/usr/bin:/cygdrive/c/WINDOWS/system32:/cygdrive/c/WINDOWS:/cygdrive/c/WINDOWS/System32/Wbem:/cygdrive/c/WINDOWS/System32/WindowsPowerShell/v1.0:/cygdrive/c/WINDOWS/System32/OpenSSH:/cygdrive/c/Users/s/AppData/Local/Microsoft/WindowsApps:/usr/lib/lapack
SAGE_PKGCONFIG=/home/s/sage-9-5-b9-many/local/lib/pkgconfig
SAGE_ROOT=/home/s/sage-9-5-b9-many
SAGE_SHARE=/home/s/sage-9-5-b9-many/local/share
SAGE_SILENT_BUILD=yes
SAGE_SRC=/home/s/sage-9-5-b9-many/src
SESSIONNAME=Console
SHELL=/bin/bash
SHLVL=4
SYSTEMDRIVE=C:
SYSTEMROOT=C:\WINDOWS
TEMP=/tmp
TERM_PROGRAM_VERSION=3.5.2
TERM_PROGRAM=mintty
TERM=xterm
TMP=/tmp
TZ=Europe/Paris
USER=s
USERDOMAIN_ROAMINGPROFILE=LAPTOP-Q6AFHV1S
USERDOMAIN=LAPTOP-Q6AFHV1S
USERNAME=s
USERPROFILE=C:\Users\s
V=0
WINDIR=C:\WINDOWS
***********************************************
make --no-print-directory /home/s/sage-9-5-b9-many/local/var/lib/sage/installed/.dummy
make --no-print-directory /home/s/sage-9-5-b9-many/local/var/lib/sage/installed/.dummy
make --no-print-directory /home/s/sage-9-5-b9-many/local/var/lib/sage/installed/.dummy
make --no-print-directory /home/s/sage-9-5-b9-many/local/var/lib/sage/installed/.dummy
[setuptools-59.2.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/setuptools-59.2.0.log
  [setuptools-59.2.0] successfully installed.
[wheel-0.37.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/wheel-0.37.0.log
  [wheel-0.37.0] successfully installed.
[pip-21.3.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pip-21.3.1.log
  [pip-21.3.1] successfully installed.
[flit_core-3.4.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/flit_core-3.4.0.log
  [flit_core-3.4.0] successfully installed.
[tomli-1.2.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/tomli-1.2.1.log
  [tomli-1.2.1] successfully installed.
[pyparsing-3.0.6] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pyparsing-3.0.6.log
  [pyparsing-3.0.6] successfully installed.
[setuptools_wheel-59.2.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/setuptools_wheel-59.2.0.log
  [setuptools_wheel-59.2.0] successfully installed.
[packaging-21.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/packaging-21.0.log
  [packaging-21.0] successfully installed.
[setuptools_scm-6.3.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/setuptools_scm-6.3.2.log
  [setuptools_scm-6.3.2] successfully installed.
[gmpy2-2.1.0rc1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/gmpy2-2.1.0rc1.log
  [gmpy2-2.1.0rc1] successfully installed.
[cython-0.29.24] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/cython-0.29.24.log
  [cython-0.29.24] successfully installed.
[pari_galdata-20080411.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pari_galdata-20080411.p0.log
  [pari_galdata-20080411.p0] successfully installed.
[pari_seadata_small-20090618.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pari_seadata_small-20090618.p0.log
  [pari_seadata_small-20090618.p0] successfully installed.
[pari-2.13.3] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pari-2.13.3.log
  [pari-2.13.3] successfully installed.
[cysignals-1.11.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/cysignals-1.11.2.log
  [cysignals-1.11.2] successfully installed.
[ppl-1.2.p1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ppl-1.2.p1.log
  [ppl-1.2.p1] successfully installed.
[pplpy-0.8.6] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pplpy-0.8.6.log
  [pplpy-0.8.6] successfully installed.
[docutils-0.17.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/docutils-0.17.1.log
  [docutils-0.17.1] successfully installed.
[markupsafe-1.1.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/markupsafe-1.1.1.log
  [markupsafe-1.1.1] successfully installed.
[jinja2-2.11.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/jinja2-2.11.2.log
  [jinja2-2.11.2] successfully installed.
[pygments-2.10.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pygments-2.10.0.log
  [pygments-2.10.0] successfully installed.
[six-1.16.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/six-1.16.0.log
  [six-1.16.0] successfully installed.
[snowballstemmer-2.1.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/snowballstemmer-2.1.0.log
  [snowballstemmer-2.1.0] successfully installed.
[imagesize-1.2.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/imagesize-1.2.0.log
  [imagesize-1.2.0] successfully installed.
[pytz-2021.3] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pytz-2021.3.log
  [pytz-2021.3] successfully installed.
[babel-2.9.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/babel-2.9.1.log
  [babel-2.9.1] successfully installed.
[alabaster-0.7.12] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/alabaster-0.7.12.log
  [alabaster-0.7.12] successfully installed.
[idna-3.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/idna-3.2.log
  [idna-3.2] successfully installed.
[urllib3-1.26.6] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/urllib3-1.26.6.log
  [urllib3-1.26.6] successfully installed.
[certifi-2021.10.8] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/certifi-2021.10.8.log
  [certifi-2021.10.8] successfully installed.
[charset_normalizer-2.0.4] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/charset_normalizer-2.0.4.log
  [charset_normalizer-2.0.4] successfully installed.
[requests-2.26.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/requests-2.26.0.log
  [requests-2.26.0] successfully installed.
[sphinxcontrib_websupport-1.2.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sphinxcontrib_websupport-1.2.1.log
  [sphinxcontrib_websupport-1.2.1] successfully installed.
[sphinxcontrib_applehelp-1.0.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sphinxcontrib_applehelp-1.0.2.log
  [sphinxcontrib_applehelp-1.0.2] successfully installed.
[sphinxcontrib_devhelp-1.0.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sphinxcontrib_devhelp-1.0.2.log
  [sphinxcontrib_devhelp-1.0.2] successfully installed.
[sphinxcontrib_htmlhelp-2.0.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sphinxcontrib_htmlhelp-2.0.0.log
  [sphinxcontrib_htmlhelp-2.0.0] successfully installed.
[sphinxcontrib_jsmath-1.0.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sphinxcontrib_jsmath-1.0.1.log
  [sphinxcontrib_jsmath-1.0.1] successfully installed.
[sphinxcontrib_qthelp-1.0.3] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sphinxcontrib_qthelp-1.0.3.log
  [sphinxcontrib_qthelp-1.0.3] successfully installed.
[sphinxcontrib_serializinghtml-1.1.5] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sphinxcontrib_serializinghtml-1.1.5.log
  [sphinxcontrib_serializinghtml-1.1.5] successfully installed.
[sphinx-4.2.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sphinx-4.2.0.log
  [sphinx-4.2.0] successfully installed.
[pplpy_doc-0.8.6] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pplpy_doc-0.8.6.log
  [pplpy_doc-0.8.6] successfully installed.
[arb-2.19.0.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/arb-2.19.0.p0.log
  [arb-2.19.0.p0] successfully installed.
[openblas-0.3.18] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/openblas-0.3.18.log
  [openblas-0.3.18] successfully installed.
[m4ri-20200115] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/m4ri-20200115.log
  [m4ri-20200115] successfully installed.
[brial-1.2.8] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/brial-1.2.8.log
  [brial-1.2.8] successfully installed.
[cliquer-1.22] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/cliquer-1.22.log
  [cliquer-1.22] successfully installed.
[cypari-2.1.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/cypari-2.1.2.log
  [cypari-2.1.2] successfully installed.
[ecl-21.2.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ecl-21.2.1.log
  [ecl-21.2.1] successfully installed.
[eclib-20210625] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/eclib-20210625.log
  [eclib-20210625] successfully installed.
[ecm-7.0.4.p2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ecm-7.0.4.p2.log
  [ecm-7.0.4.p2] successfully installed.
[gap-4.11.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/gap-4.11.1.log
  [gap-4.11.1] successfully installed.
[mpfi-1.5.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/mpfi-1.5.2.log
  [mpfi-1.5.2] successfully installed.
[gsl-2.7] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/gsl-2.7.log
  [gsl-2.7] successfully installed.
[giac-1.6.0.47p3] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/giac-1.6.0.47p3.log
  [giac-1.6.0.47p3] successfully installed.
[givaro-4.1.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/givaro-4.1.1.log
  [givaro-4.1.1] successfully installed.
[iml-1.0.4p1.p2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/iml-1.0.4p1.p2.log
  [iml-1.0.4p1.p2] successfully installed.
[ipython_genutils-0.2.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ipython_genutils-0.2.0.log
  [ipython_genutils-0.2.0] successfully installed.
[decorator-4.4.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/decorator-4.4.2.log
  [decorator-4.4.2] successfully installed.
[traitlets-5.1.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/traitlets-5.1.1.log
  [traitlets-5.1.1] successfully installed.
[jupyter_core-4.9.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/jupyter_core-4.9.1.log
  [jupyter_core-4.9.1] successfully installed.
[lcalc-2.0.5] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/lcalc-2.0.5.log
  [lcalc-2.0.5] successfully installed.
[lrcalc-1.2.p1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/lrcalc-1.2.p1.log
  [lrcalc-1.2.p1] successfully installed.
[libbraiding-1.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/libbraiding-1.1.log
  [libbraiding-1.1] successfully installed.
[libhomfly-1.02r6] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/libhomfly-1.02r6.log
  [libhomfly-1.02r6] successfully installed.
[fplll-5.4.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/fplll-5.4.1.log
  [fplll-5.4.1] successfully installed.
[fflas_ffpack-2.4.3.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/fflas_ffpack-2.4.3.p0.log
  [fflas_ffpack-2.4.3.p0] successfully installed.
[linbox-1.6.3.p1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/linbox-1.6.3.p1.log
  [linbox-1.6.3.p1] successfully installed.
[m4rie-20200115] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/m4rie-20200115.log
  [m4rie-20200115] successfully installed.
[memory_allocator-0.1.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/memory_allocator-0.1.1.log
  [memory_allocator-0.1.1] successfully installed.
[pkgconfig-1.5.5] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pkgconfig-1.5.5.log
  [pkgconfig-1.5.5] successfully installed.
[numpy-1.21.4] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/numpy-1.21.4.log
  [numpy-1.21.4] successfully installed.
[planarity-3.0.1.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/planarity-3.0.1.0.log
  [planarity-3.0.1.0] successfully installed.
[primesieve-7.6] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/primesieve-7.6.log
  [primesieve-7.6] successfully installed.
[primecount-7.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/primecount-7.1.log
  [primecount-7.1] successfully installed.
[primecountpy-0.1.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/primecountpy-0.1.0.log
  [primecountpy-0.1.0] successfully installed.
[pycygwin-0.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pycygwin-0.1.log
  [pycygwin-0.1] successfully installed.
[ratpoints-2.1.3.p5] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ratpoints-2.1.3.p5.log
  [ratpoints-2.1.3.p5] successfully installed.
[rw-0.9] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/rw-0.9.log
  [rw-0.9] successfully installed.
[sage_conf-9.5.beta9] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sage_conf-9.5.beta9.log
  [sage_conf-9.5.beta9] successfully installed.
[singular-4.2.1p3] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/singular-4.2.1p3.log
  [singular-4.2.1p3] successfully installed.
[symmetrica-3.0.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/symmetrica-3.0.1.log
  [symmetrica-3.0.1] successfully installed.
[zn_poly-0.9.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/zn_poly-0.9.2.log
  [zn_poly-0.9.2] successfully installed.
[sage_setup-9.5.beta9] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sage_setup-9.5.beta9.log
  [sage_setup-9.5.beta9] successfully installed.
[sagelib-9.5.beta9] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sagelib-9.5.beta9.log
  [sagelib-9.5.beta9] successfully installed.
[tornado-6.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/tornado-6.1.log
  [tornado-6.1] successfully installed.
[zeromq-4.3.4] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/zeromq-4.3.4.log
  [zeromq-4.3.4] successfully installed.
[pyzmq-22.3.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pyzmq-22.3.0.log
  [pyzmq-22.3.0] successfully installed.
[pickleshare-0.7.5] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pickleshare-0.7.5.log
  [pickleshare-0.7.5] successfully installed.
[simplegeneric-0.8.1.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/simplegeneric-0.8.1.p0.log
  [simplegeneric-0.8.1.p0] successfully installed.
[wcwidth-0.2.5] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/wcwidth-0.2.5.log
  [wcwidth-0.2.5] successfully installed.
[prompt_toolkit-3.0.22] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/prompt_toolkit-3.0.22.log
  [prompt_toolkit-3.0.22] successfully installed.
[ptyprocess-0.5.1.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ptyprocess-0.5.1.p0.log
  [ptyprocess-0.5.1.p0] successfully installed.
[pexpect-4.8.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pexpect-4.8.0.log
  [pexpect-4.8.0] successfully installed.
[appnope-0.1.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/appnope-0.1.2.log
  [appnope-0.1.2] successfully installed.
[backcall-0.2.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/backcall-0.2.0.log
  [backcall-0.2.0] successfully installed.
[parso-0.8.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/parso-0.8.2.log
  [parso-0.8.2] successfully installed.
[jedi-0.18.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/jedi-0.18.1.log
  [jedi-0.18.1] successfully installed.
[ipython-7.29.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ipython-7.29.0.log
  [ipython-7.29.0] successfully installed.
[maxima-5.45.0.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/maxima-5.45.0.p0.log
  [maxima-5.45.0.p0] successfully installed.
[pybind11-2.8.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pybind11-2.8.1.log
  [pybind11-2.8.1] successfully installed.
[gast-0.5.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/gast-0.5.2.log
  [gast-0.5.2] successfully installed.
[beniget-0.4.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/beniget-0.4.1.log
  [beniget-0.4.1] successfully installed.
[ply-3.11] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ply-3.11.log
  [ply-3.11] successfully installed.
[pythran-0.10.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pythran-0.10.0.log
  [pythran-0.10.0] successfully installed.
[scipy-1.7.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/scipy-1.7.2.log
  [scipy-1.7.2] successfully installed.
[networkx-2.6.3] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/networkx-2.6.3.log
  [networkx-2.6.3] successfully installed.
[mpmath-1.2.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/mpmath-1.2.1.log
  [mpmath-1.2.1] successfully installed.
[sympy-1.9] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sympy-1.9.log
  [sympy-1.9] successfully installed.
[pillow-8.4.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/pillow-8.4.0.log
  [pillow-8.4.0] successfully installed.
[dateutil-2.8.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/dateutil-2.8.2.log
  [dateutil-2.8.2] successfully installed.
[cycler-0.11.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/cycler-0.11.0.log
  [cycler-0.11.0] successfully installed.
[fonttools-4.28.4] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/fonttools-4.28.4.log
  [fonttools-4.28.4] successfully installed.
[cppy-1.1.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/cppy-1.1.0.log
  [cppy-1.1.0] successfully installed.
[kiwisolver-1.3.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/kiwisolver-1.3.2.log
  [kiwisolver-1.3.2] successfully installed.
[setuptools_scm_git_archive-1.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/setuptools_scm_git_archive-1.1.log
  [setuptools_scm_git_archive-1.1] successfully installed.
[matplotlib-3.5.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/matplotlib-3.5.1.log
  [matplotlib-3.5.1] successfully installed.
[mathjax-2.7.4.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/mathjax-2.7.4.p0.log
  [mathjax-2.7.4.p0] successfully installed.
[vcversioner-2.16.0.0.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/vcversioner-2.16.0.0.p0.log
  [vcversioner-2.16.0.0.p0] successfully installed.
[zipp-3.5.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/zipp-3.5.0.log
  [zipp-3.5.0] successfully installed.
[typing_extensions-3.10.0.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/typing_extensions-3.10.0.0.log
  [typing_extensions-3.10.0.0] successfully installed.
[importlib_metadata-4.8.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/importlib_metadata-4.8.2.log
  [importlib_metadata-4.8.2] successfully installed.
[argcomplete-1.12.3] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/argcomplete-1.12.3.log
  [argcomplete-1.12.3] successfully installed.
[matplotlib_inline-0.1.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/matplotlib_inline-0.1.2.log
  [matplotlib_inline-0.1.2] successfully installed.
[nest_asyncio-1.5.1] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/nest_asyncio-1.5.1.log
  [nest_asyncio-1.5.1] successfully installed.
[entrypoints-0.3] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/entrypoints-0.3.log
  [entrypoints-0.3] successfully installed.
[jupyter_client-7.1.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/jupyter_client-7.1.0.log
  [jupyter_client-7.1.0] successfully installed.
[ipykernel-6.6.0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ipykernel-6.6.0.log
  [ipykernel-6.6.0] successfully installed.
[conway_polynomials-0.5] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/conway_polynomials-0.5.log
  [conway_polynomials-0.5] successfully installed.
[tachyon-0.98.9.p7] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/tachyon-0.98.9.p7.log
  [tachyon-0.98.9.p7] successfully installed.
[jmol-14.29.52] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/jmol-14.29.52.log
  [jmol-14.29.52] successfully installed.
[thebe-9624e0a0.p0] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/thebe-9624e0a0.p0.log
  [thebe-9624e0a0.p0] successfully installed.
[widgetsnbextension-3.5.2] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/widgetsnbextension-3.5.2.log
  [widgetsnbextension-3.5.2] successfully installed.
[ipywidgets-7.6.5] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/ipywidgets-7.6.5.log
  [ipywidgets-7.6.5] successfully installed.
[sage_docbuild-9.5.beta9] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sage_docbuild-9.5.beta9.log
  [sage_docbuild-9.5.beta9] successfully installed.
[sagemath_doc_html-none] installing. Log file: /home/s/sage-9-5-b9-many/logs/pkgs/sagemath_doc_html-none.log
  [sagemath_doc_html-none] error installing, exit status 2. End of log file:
  [sagemath_doc_html-none]   [reference] WARNING: Unable to fetch /home/s/sage-9-5-b9-many/local/share/doc/sage/doctrees/en/reference/categories/environment.pickle
  [sagemath_doc_html-none]   [reference] WARNING: Unable to fetch /home/s/sage-9-5-b9-many/local/share/doc/sage/doctrees/en/reference/coding/environment.pickle
  [sagemath_doc_html-none]   [reference] WARNING: Unable to fetch /home/s/sage-9-5-b9-many/local/share/doc/sage/doctrees/en/reference/combinat/environment.pickle
  [sagemath_doc_html-none]   [reference] WARNING: Unable to fetch /home/s/sage-9-5-b9-many/local/share/doc/sage/doctrees/en/reference/graphs/environment.pickle
  [sagemath_doc_html-none]   [reference] WARNING: Unable to fetch /home/s/sage-9-5-b9-many/local/share/doc/sage/doctrees/en/reference/groups/environment.pickle
  [sagemath_doc_html-none]   [reference] WARNING: Unable to fetch /home/s/sage-9-5-b9-many/local/share/doc/sage/doctrees/en/reference/knots/environment.pickle
  [sagemath_doc_html-none]   [reference] WARNING: Unable to fetch /home/s/sage-9-5-b9-many/local/share/doc/sage/doctrees/en/reference/libs/environment.pickle
  [sagemath_doc_html-none]   [reference] preparing documents... skipping loading of indexes... done
  [sagemath_doc_html-none]   [reference] /home/s/sage-9-5-b9-many/src/doc/en/reference/index.rst:35: WARNING: unknown document: categories/index
  [sagemath_doc_html-none]   [reference] /home/s/sage-9-5-b9-many/src/doc/en/reference/index.rst:77: WARNING: unknown document: groups/index
  [sagemath_doc_html-none]   [reference] /home/s/sage-9-5-b9-many/src/doc/en/reference/index.rst:80: WARNING: unknown document: algebras/index
  [sagemath_doc_html-none]   [reference] /home/s/sage-9-5-b9-many/src/doc/en/reference/index.rst:85: WARNING: unknown document: combinat/index
  [sagemath_doc_html-none]   [reference] /home/s/sage-9-5-b9-many/src/doc/en/reference/index.rst:86: WARNING: unknown document: graphs/index
  [sagemath_doc_html-none]   [reference] /home/s/sage-9-5-b9-many/src/doc/en/reference/index.rst:90: WARNING: unknown document: coding/index
  [sagemath_doc_html-none]   [reference] /home/s/sage-9-5-b9-many/src/doc/en/reference/index.rst:105: WARNING: unknown document: knots/index
  [sagemath_doc_html-none]   [reference] /home/s/sage-9-5-b9-many/src/doc/en/reference/index.rst:156: WARNING: unknown document: libs/index
  [sagemath_doc_html-none]   [reference] The inventory files are in local/share/doc/sage/inventory/en/reference.
  [sagemath_doc_html-none]   Error building the documentation.
  [sagemath_doc_html-none]   Traceback (most recent call last):
  [sagemath_doc_html-none]     File "/usr/lib/python3.9/runpy.py", line 197, in _run_module_as_main
  [sagemath_doc_html-none]       return _run_code(code, main_globals, None,
  [sagemath_doc_html-none]     File "/usr/lib/python3.9/runpy.py", line 87, in _run_code
  [sagemath_doc_html-none]       exec(code, run_globals)
  [sagemath_doc_html-none]     File "/home/s/sage-9-5-b9-many/local/var/lib/sage/venv-python3.9/lib/python3.9/site-packages/sage_docbuild/__main__.py", line 2, in <module>
  [sagemath_doc_html-none]       main()
  [sagemath_doc_html-none]     File "/home/s/sage-9-5-b9-many/local/var/lib/sage/venv-python3.9/lib/python3.9/site-packages/sage_docbuild/__init__.py", line 1775, in main
  [sagemath_doc_html-none]       builder()
  [sagemath_doc_html-none]     File "/home/s/sage-9-5-b9-many/local/var/lib/sage/venv-python3.9/lib/python3.9/site-packages/sage_docbuild/__init__.py", line 137, in f
  [sagemath_doc_html-none]       runsphinx()
  [sagemath_doc_html-none]     File "/home/s/sage-9-5-b9-many/local/var/lib/sage/venv-python3.9/lib/python3.9/site-packages/sage_docbuild/sphinxbuild.py", line 323, in runsphinx
  [sagemath_doc_html-none]       sys.stderr.raise_errors()
  [sagemath_doc_html-none]     File "/home/s/sage-9-5-b9-many/local/var/lib/sage/venv-python3.9/lib/python3.9/site-packages/sage_docbuild/sphinxbuild.py", line 258, in raise_errors
  [sagemath_doc_html-none]       raise OSError(self._error)
  [sagemath_doc_html-none]   OSError: WARNING: Unable to fetch /home/s/sage-9-5-b9-many/local/share/doc/sage/doctrees/en/reference/algebras/environment.pickle
  [sagemath_doc_html-none]
  [sagemath_doc_html-none]       Note: incremental documentation builds sometimes cause spurious
  [sagemath_doc_html-none]       error messages. To be certain that these are real errors, run
  [sagemath_doc_html-none]       "make doc-clean doc-uninstall" first and try again.
  [sagemath_doc_html-none]   make[6]: *** [Makefile:20: doc-inventory--reference_top] Error 1
  [sagemath_doc_html-none]   make[5]: *** [Makefile:38: doc-inventory-reference] Error 2
  [sagemath_doc_html-none] Full log file: /home/s/sage-9-5-b9-many/logs/pkgs/sagemath_doc_html-none.log
make[4]: *** [Makefile:2859: sagemath_doc_html-SAGE_DOCS-no-deps] Error 2
make[3]: *** [Makefile:2859: /home/s/sage-9-5-b9-many/local/var/lib/sage/installed/sagemath_doc_html-none] Error 2
make[2]: *** [Makefile:2420: all-start] Error 2

real    909m21.582s
user    812m25.061s
sys     207m16.986s
***************************************************************
Error building Sage.

The following package(s) may have failed to build (not necessarily
during this run of 'make all-start'):

It is safe to delete any log files and build directories, but they
contain information that is helpful for debugging build problems.
WARNING: If you now run 'make' again, the build directory of the
same version of the package will, by default, be deleted. Set the
environment variable SAGE_KEEP_BUILT_SPKGS=yes to prevent this.

make[1]: *** [Makefile:39: all-start] Error 1
make: *** [Makefile:13: all] Error 2
```
